import vfo.vfo as vfo
import openseespy.opensees as op
import numpy as np
from math import asin, sqrt
# set some properties
from openseespy.opensees import *
import pandas as pd
import matplotlib.pyplot as plt
np.set_printoptions(suppress=True)

def getdata(DamageLevel,DamagedElements,seed):
	"""
    This program is trying to get the raw timehistory data from the Beam model
    :param DamageLevel: 0,0.25 or 0.5 ,level of damage
    :param DamagedElements: [],can be random choose which elements are damaged or no damaged
    :param seed: seed to reproduce the experiment
    :return: raw datasets 
    """
    # units
    N = 1
    sec = 1
    m = 1
    m2 = m*m
    m3 = m**3
    m4 = m**4
    mm = 0.001*m
    mm2=mm**2
    mm4=mm**4
    kg = 1
    Pa = 1.*N /m2
    MPa = 1e6*Pa
    Gpa = 1e9*pa
    N=1.;kN=1000.*N

    # Define input paramters
    ElasticModulus=210*GPa
    Area=0.01 # 2.81e-3*m2
    Inertia=8.33e-06 #1.845e-8*m4
    DamageLevel=1-float(DamageLevel)
    AreaDamaged=Area*DamageLevel
    InertiaDamaged=Inertia*DamageLevel
    MassDensity=77008.5*N/m3
    Nnodes=6 # remember: N elements , N+1 nodes if count from 1... In this case count start from 0!!
    L=2*m
  


    # MODEL generation

    wipe()
    model('Basic','-ndm',3,'-ndf',3)

    for ii in range(Nnodes+1):
        ops.node(ii, ii*L/Nnodes, 0, 0) # create nodes
    
    # set boundary condition: simply supported pin-roller
    fix(     0, 1, 1, 0)
    fix(Nnodes, 0, 1, 0)

    # define materials
    uniaxialMaterial("Elastic", 1, ElasticModulus)

    # define elements
    # define geometric transformation: performs a linear geometric transformation of beam stiffness and resisting force from the basic system to the global-coordinate system
    coordTransf = "Linear"  
    massType = "-lMass"  
    geomTransf(coordTransf, 1)
    Ew= {} # Ew Python dictionary contains information on non-zero element loads, therfore each item of the Python dictionary is in the form: 'ele_tag: ['-beamUniform', Wy, Wx]'.
    Wy=-MassDensity*Area  # Vertical self weight
    Wx=0.
    selfweightpointload=Wy*(L/Nnodes)/2
    for ii in range(Nnodes):
        if ii in DamagedElements:
            lement("elasticBeamColumn",ii+1,ii,ii+1,AreaDamaged,ElasticModulus,InertiaDamaged,1,'-mass', MassDensity, massType)
            Ew[ii+1] = ['-beamUniform', Wy*DamageLevel, Wx] 
        else:
            element("elasticBeamColumn",ii+1,ii,ii+1,Area,ElasticModulus,Inertia,1,'-mass', MassDensity, massType)
            Ew[ii+1] = ['-beamUniform', Wy, Wx] 
    # define GRAVITY 
    timeSeries('Linear', 1)
    pattern('Plain', 1, 1)
    for etag in Ew: # self weight for each beam element
        # print(int(etag),Ew[etag][0], Ew[etag][1], Ew[etag][2])
        # print(f'sto caricando elemento {etag}')
        eleLoad('-ele', etag, '-type', Ew[etag][0],Ew[etag][1], Ew[etag][2])

    # define static analysis object 
    constraints('Plain')  				# how it handles boundary conditions
    numberer('Plain')			        # renumber dof's to minimize band-width (optimization), if you want to
    system('BandGeneral')		        # how to store and solve the system of equations in the analysis
    algorithm('Linear')                 # use Linear algorithm for linear analysis
    integrator('LoadControl', 0.1)		# determine the next time step for an analysis, # apply gravity in 10 steps
    analysis('Static')					# define type of analysis static or transient
    analyze(10)					    # perform gravity analysis
    loadConst('-time', 0.0)				# hold gravity constant and restart time

    print(f'ok: {ok}\n') # if analysis no problems then ok=0

 	
	# DYNAMIC ground-motion analysis 
	G = 1 # acceleration is already in m/s^2
	dtAccFile=0.02 # 50 Hz
    nPtsAccFile=15001
    timeSeries('Path', 2, '-dt', dtAccFile, '-filePath', f'whitenoise/whitenoiseAcceleration_{seed}.dat', '-factor', G) # define acceleration vector from file (dt=0.005 is associated with the input file gm)
   	pattern('MultipleSupport', 2)
    groundMotion(1,'Plain','-accel',2)
    # imposedMotion(nodeTag, dof, gmTag)
    imposedMotion(Nnodes, 2, 1)
	rayleigh(0.0, 0.0, 0.0, 0.000625)

   
    wipeAnalysis() # clear previously-define analysis parameters
    constraints('Plain') # how it handles boundary conditions
    numberer('Plain') # renumber dof's to minimize band-width (optimization), if you want to
    system('BandGeneral') # how to store and solve the system of equations in the analysis
	test('NormDispIncr', 1.0e-12, 10 )
    algorithm('Linear') # use Linear algorithm for linear analysis
    integrator('Newmark', 0.5, 0.25) # determine the next time step for an analysis, Newmark with alpha =0.5 and beta =.25
    analysis('Transient') # define type of analysis: time-dependent

    dt=0.002
    nPts=150001

    # set some variables
    tFinal = nPts*dt
    tCurrent = ops.getTime()
    ok = 0

    time = [tCurrent]
    OutputDispMatrix = zeros((nPts+1,Nnodes+1))
    OutputAccelMatrix = zeros((nPts+1,Nnodes+1))
    jj=1
    # Perform the transient analysis
    while ok == 0 and tCurrent < tFinal:

        ok = analyze(1, dt)
        # if the analysis fails try initial tangent iteration
        if ok != 0:
            print("regular newton failed .. lets try an initial stiffness for this step")
            ops.test('NormDispIncr', 1.0e-12, 100, 0)
            ops.algorithm('ModifiedNewton', '-initial')
            ok =ops.analyze( 1, dt)
            if ok == 0:
                print("that worked .. back to regular newton")
                ops.test('NormDispIncr', 1.0e-12, 10 )
                ops.algorithm('Newton')
            
        tCurrent = ops.getTime()
        time.append(tCurrent)
        try:
            for ii in range(Nnodes+1): # collect outputs in matrix form
                OutputDispMatrix[jj,ii]=ops.nodeDisp(ii,2)
                OutputAccelMatrix[jj,ii]=ops.nodeAccel(ii,2)
        except IndexError:
            A,B=np.zeros((1,Nnodes+1)),np.zeros((1,Nnodes+1))
            for ii in range(Nnodes+1):
                A[0,ii]=ops.nodeDisp(ii,2)
                B[0,ii]=ops.nodeAccel(ii,2)
            OutputDispMatrix=np.concatenate((OutputDispMatrix,A),axis=0)
            OutputAccelMatrix=np.concatenate((OutputAccelMatrix,B),axis=0)
        jj+=1
  
	wipe()
	np.savetxt(f'Database/OutputAccelMatrixDAMAGED_seed_{seed}_damage_{1-DamageLevel}.txt',OutputAccelMatrix,fmt='%.6f')
    